﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Registry.master" AutoEventWireup="true" CodeFile="AdminEditUsersRoles.aspx.cs" Inherits="AdminEditUsersRoles" MaintainScrollPositionOnPostback="true" %>
<%@ Register src="controls/ErrorList.ascx" tagname="ErrorList" tagprefix="uc1" %>
<%@ Import  Namespace="System.Web.Security.AntiXss" %>
<asp:Content ID="Content1" ContentPlaceHolderID="head" Runat="Server">
    <style type="text/css">
        .style2
        {
            width: 150px;
        }
        .style3
        {
            width: 20px;
        }
        .style4
        {
            width: 100%;
        }
        .style5
        {
        }
        .style6
        {
            width: 23px;
        }
    </style>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder" Runat="Server">
    <asp:ScriptManager ID="ScriptManager1" runat="server">
    </asp:ScriptManager>
    
    <script type = "text/javascript">

        $(function() {
            if ($('#<%= HiddenFieldClearFlag.ClientID %>').val() === '1')
                $('#<%= TextBoxSearchCriteria.ClientID%>').focus();

        });
    </script>
    
    <div class="breadcrumb">
        <asp:Label SkinID="DataLabel" ID = "LabelBreadCrumb" runat="server" Text="Administration "/>
    </div>    
    <asp:Panel ID="PanelObjectContent" runat="server">
        <br /><uc1:ErrorList ID="ErrorList1" runat="server" />
        
        <div class = "excludeSaveWarnings">
        <asp:Panel ID="PanelListUserRoles" runat="server" GroupingText="User / Roles&nbsp;&nbsp;" Width="95%">
        <br />
            <asp:Label SkinID="DataLabel" ID="LabelforTextBoxSearchCriteria" runat="server" AssociatedControlID="TextBoxSearchCriteria">Search:</asp:Label>
                <asp:TextBox ID="TextBoxSearchCriteria" runat="server" Width="100">
                </asp:TextBox>
                &nbsp;
                <asp:Button ID="ButtonSearch" runat="server" Text=" Search " OnClick = "OKButton_Click" />
                &nbsp;
                <asp:Button ID="ButtonClear" runat="server" Text=" Clear " 
                    onclick="ButtonClear_Click" />
                <asp:HiddenField ID="HiddenFieldClearFlag" runat="server" />
                <br />
                <br />
                <asp:GridView ID="GridViewUserRoles" runat="server" DataKeyNames="USER_ROLE_ID"
                    DataSourceID="ObjectDataSourceUsersRoles" AutoGenerateColumns="False" 
                    AllowPaging="True"
                    AllowSorting="True" Caption="Users" EmptyDataText="No User Roles">
                    <Columns>
                        <asp:HyperLinkField DataNavigateUrlFields="USER_ID" SortExpression="USER_ID" NavigateUrl="~/AdminEditUsersRoles.aspx"
                            ItemStyle-HorizontalAlign="Center" HeaderStyle-HorizontalAlign="Center"
                            DataNavigateUrlFormatString="AdminEditUsersRoles.aspx?id={0}"
                            DataTextField="USER_ID" HeaderText="ID">
                            <HeaderStyle HorizontalAlign="Center"></HeaderStyle>
                            <ItemStyle HorizontalAlign="Center" Width="18px"></ItemStyle>
                        </asp:HyperLinkField>
                        <asp:TemplateField HeaderText="NT Username" SortExpression="USER.USERNAME">
                           <ItemTemplate>
                                <asp:Label SkinID="DataLabel" ID="LabelUserName" runat="server" Text='<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("USER.USERNAME")), false) %>'></asp:Label>
                            </ItemTemplate>
                            <HeaderStyle HorizontalAlign="Left" />
                            <ItemStyle HorizontalAlign="Left" />
                        </asp:TemplateField>
                        <asp:TemplateField HeaderText="Full Name" SortExpression="USER.FULL_NAME">
                           <ItemTemplate>
                                <asp:Label SkinID="DataLabel" ID="LabelFullName" runat="server" Text='<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("USER.FULL_NAME")), false) %>'></asp:Label>
                            </ItemTemplate>
                            <HeaderStyle HorizontalAlign="Left" />
                            <ItemStyle HorizontalAlign="Left" />
                        </asp:TemplateField>
                        <asp:TemplateField HeaderText="Role" SortExpression="STD_ROLE.NAME">
                           <ItemTemplate>
                                <asp:Label SkinID="DataLabel" ID="LabelRoleName" runat="server" Text='<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("STD_ROLE.NAME")),false) %>'></asp:Label>
                            </ItemTemplate>
                            <HeaderStyle HorizontalAlign="Left" />
                            <ItemStyle HorizontalAlign="Left" />
                        </asp:TemplateField>
                    </Columns>
                </asp:GridView>
                <br />
                <asp:Button ID="ButtonDownloadToExcel" runat="server" onclick="ButtonDownloadToExcel_Click" 
                    Text="Download To Excel" />
                <br />
                <br />
                <asp:ObjectDataSource ID="ObjectDataSourceUsersRoles" runat="server" 
                    SelectMethod="SelectListUsersVISNs" 
                    SelectCountMethod="SelectListUsersVISNsCount"
                    StartRowIndexParameterName="startRow" 
                    MaximumRowsParameterName="maxRows" 
                    SortParameterName="sort"
                    EnablePaging="True"  
                    TypeName="VeteransAffairs.Registries.BusinessManager.UsersManager" 
                    DeleteMethod="RemoveUserFromRegistry">
                    <DeleteParameters>
                        <asp:ControlParameter ControlID="HiddenFieldRegistryName" DefaultValue="EFR" 
                            Name="RegistryCode" PropertyName="Value" Type="String" />
                    </DeleteParameters>
                    <SelectParameters>
                        <asp:ControlParameter ControlID="HiddenFieldRegistryName" DefaultValue="EFR" 
                            Name="RegistryCode" PropertyName="Value" Type="String" />
                        <asp:ControlParameter ControlID="TextBoxSearchCriteria" DefaultValue=""
                            Name="searchCriteria" PropertyName="Text" Type="String" />
                        <asp:Parameter Name="sort" Type="String" />
                        <asp:Parameter Name="startRow" Type="Int32" />
                        <asp:Parameter Name="maxRows" Type="Int32" />
                    </SelectParameters>
                </asp:ObjectDataSource>
        </asp:Panel>
        </div> 
        <asp:Panel ID="PanelRoleInformation" runat="server" GroupingText="Edit User Role Information" 
            Width="65%">
            <br />
            <asp:Panel ID="PanelUserProfile" runat="server" GroupingText="&nbsp;User Profile&nbsp;&nbsp;" 
            Width="98%">
                <table border="0" width="100%" >
                    <tr>
                        <td class="style2">
                            <asp:Label ID="LabelforLabelUsername" runat="server" 
                                AssociatedControlID="LabelUsername" SkinID="DataLabel">NT Username:</asp:Label>
                                </td>
                        <td>
                            <asp:Label ID="LabelUsername" runat="server"  Text="Username" 
                                SkinID="DataLabel"></asp:Label>
                        </td>
                        <td class="style3">
                            &nbsp;</td>
                    </tr>
                    <tr>
                        <td colspan="3">
                            <hr />
                        </td>
                    </tr>
                    <tr>
                        <td class="style2">
                            <asp:Label ID="LabelforLabelFullName" runat="server" 
                                AssociatedControlID="LabelFullName" SkinID="DataLabel">Full Name:</asp:Label>
                                </td>
                        <td>
                            <asp:Label ID="LabelFullName" runat="server"  Text="Full Name" 
                                SkinID="DataLabel"></asp:Label>
                        </td>
                        <td class="style3">
                            &nbsp;</td>
                    </tr>
                    <tr>
                        <td class="style2">
                            <asp:Label ID="LabelforLabelEmployeeNumber" runat="server" 
                                AssociatedControlID="LabelEmployeeNumber" SkinID="DataLabel">Employee Number:</asp:Label>
                                </td>
                        <td>
                            <asp:Label ID="LabelEmployeeNumber" runat="server"  
                                Text="Employee Number:" SkinID="DataLabel"></asp:Label>
                        </td>
                        <td class="style3">
                            &nbsp;</td>
                    </tr>
                    <tr>
                        <td class="style2">
                            <asp:Label ID="LabelforLabelJobTitle" runat="server" 
                                AssociatedControlID="LabelJobTitle" SkinID="DataLabel">Job Title:</asp:Label>
                                </td>
                        <td>
                            <asp:Label ID="LabelJobTitle" runat="server"  
                                Text="Job Title:" SkinID="DataLabel"></asp:Label>
                        </td>
                        <td class="style3">
                            &nbsp;</td>
                    </tr>
                </table>
                <asp:HiddenField ID="HiddenFieldUserID" runat="server" />
                <asp:HiddenField ID="HiddenFieldBreadCrumbBaseText" runat="server" />
            </asp:Panel>
            <br />
            <asp:Panel ID="PanelRoles" runat="server" GroupingText="&nbsp; Roles &nbsp;&nbsp;" 
            Width="98%">
                <table class="style4" >
                    <tr>
                        <td class="style5" colspan="2">
                            <asp:CheckBox ID="CheckBoxRoleEfrTefscAdministrator" runat="server" 
                            Text="Admin Staff" />
                        </td>
                    </tr>
                    <tr>
                        <td class="style5" colspan="2">
                            <asp:CheckBox ID="CheckBoxRoleEfrTefscCoordinator" runat="server" 
                                Text="TEFSC Coordinator (Super User)" />
                        </td>
                    </tr>
                    <tr>
                        <td class="style5" colspan="2">
                            <asp:CheckBox ID="CheckBoxRoleEfrTefscProvider" runat="server" 
                                Text="TEFSC Provider"/>
                        </td>
                    </tr>
                    <tr>
                        <td class="style5" colspan="2">
                            <asp:CheckBox ID="CheckBoxRoleEfrTefscNurse" runat="server" 
                                Text="TEFSC Nurse" />
                        </td>
                    </tr>
                    <tr>
                        <td class="style5" colspan="2">
                            <asp:CheckBox ID="CheckBoxRoleEfrTefscDataEntryPersonnel" runat="server" 
                                Text="TEFSC Data Entry Personnel" />
                        </td>
                    </tr>
                </table>
            </asp:Panel>
            <br />
            <asp:CheckBoxList ID="CheckBoxListUserRoles" runat="server" 
                RepeatDirection="Vertical" RepeatColumns="0" RepeatLayout="Table"
                        DataSourceID="" DataTextField="NAME" 
                        DataValueField="ID" Visible="False">
            </asp:CheckBoxList>
            <br />
            <br />
            <asp:Button ID="ButtonSave" runat="server" onclick="ButtonSave_Click" 
                Text="  Save  " />
            &nbsp;&nbsp;
            <asp:Button ID="ButtonClose" runat="server" onclick="ButtonClose_Click" 
                Text="  Close  " UseSubmitBehavior = "false" CssClass = "cancel" />
            <br />
            <asp:ObjectDataSource ID="ObjectDataRegistryRoles" runat="server" 
                    SelectMethod="SelectActiveByRegistryCode" 
                    TypeName="VeteransAffairs.Registries.BusinessManager.RoleManager"> 
                    <SelectParameters>
                        <asp:ControlParameter ControlID="HiddenFieldRegistryName" DefaultValue="EFR" 
                            Name="RegistryCode" PropertyName="Value" Type="String" />
                    </SelectParameters>
            </asp:ObjectDataSource>
        </asp:Panel>
    </asp:Panel>
    <asp:Panel ID="PanelNoAccess" runat="server" Visible="false">
            You do not have access to the user id supplied.
            <br /><br />
            Please contact the Registry Manager to grant access or verify that your permissions are correct.
    </asp:Panel>
    <asp:Panel ID="PanelIdNotFound" runat="server" Visible="false">
            No record found for the user ID supplied.
            <br />
            <br />
            If you tried accessing using a link within an email or typed the link in the browser, please check the link to ensure you have supplied a correct id.
    </asp:Panel>
    <asp:HiddenField ID="HiddenFieldRegistryName" runat="server" />      
</asp:Content>
